/*
 * Decompiled with CFR 0.152.
 */
package appeng.blockentity.misc;

import appeng.api.ids.AETags;
import appeng.api.implementations.IPowerChannelState;
import appeng.api.implementations.blockentities.ICrankable;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.util.AECableType;
import appeng.blockentity.grid.AENetworkBlockEntity;
import appeng.capabilities.Capabilities;
import appeng.core.AEConfig;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Nullable;

public class QuartzGrowthAcceleratorBlockEntity
extends AENetworkBlockEntity
implements IPowerChannelState {
    public static final int MAX_STORED_POWER = 1600;
    private static final int POWER_PER_TICK = 8;
    private boolean hasPower = false;
    private float storedPower;

    public QuartzGrowthAcceleratorBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState blockState) {
        super(blockEntityType, pos, blockState);
        this.getMainNode().setExposedOnSides(EnumSet.noneOf(Direction.class));
        this.getMainNode().setFlags(new GridFlags[0]);
        this.getMainNode().setIdlePowerUsage(8.0);
        this.getMainNode().addService(IGridTickable.class, new IGridTickable(){

            @Override
            public TickingRequest getTickingRequest(IGridNode node) {
                int speed = AEConfig.instance().getGrowthAcceleratorSpeed();
                return new TickingRequest(speed, speed, false, false);
            }

            @Override
            public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
                QuartzGrowthAcceleratorBlockEntity.this.onTick(ticksSinceLastCall);
                return TickRateModulation.SAME;
            }
        });
    }

    private void onTick(int ticksSinceLastCall) {
        if (this.storedPower > 0.0f) {
            this.storedPower -= (float)(8 * Math.max(1, ticksSinceLastCall));
            if (this.storedPower <= 0.0f) {
                this.storedPower = 0.0f;
                this.markForUpdate();
            }
        } else if (!this.getMainNode().isPowered()) {
            return;
        }
        for (Direction direction : Direction.values()) {
            BlockPos adjPos = this.m_58899_().m_121945_(direction);
            BlockState adjState = this.m_58904_().m_8055_(adjPos);
            if (!adjState.m_204336_(AETags.GROWTH_ACCELERATABLE)) continue;
            adjState.m_222972_((ServerLevel)this.m_58904_(), adjPos, this.m_58904_().m_213780_());
        }
    }

    @Override
    public void onMainNodeStateChanged(IGridNodeListener.State reason) {
        if (reason == IGridNodeListener.State.POWER) {
            this.markForUpdate();
        }
    }

    @Override
    public AECableType getCableConnectionType(Direction dir) {
        return AECableType.COVERED;
    }

    @Override
    public boolean readFromStream(FriendlyByteBuf data) {
        boolean c = super.readFromStream(data);
        boolean hadPower = this.isPowered();
        this.setPowered(data.readBoolean());
        return this.isPowered() != hadPower || c;
    }

    @Override
    public void writeToStream(FriendlyByteBuf data) {
        super.writeToStream(data);
        data.writeBoolean(this.getMainNode().isPowered());
    }

    @Override
    public void setOrientation(Direction inForward, Direction inUp) {
        super.setOrientation(inForward, inUp);
        this.getMainNode().setExposedOnSides(EnumSet.of(this.getUp(), this.getUp().m_122424_()));
    }

    @Override
    public void onReady() {
        this.getMainNode().setExposedOnSides(EnumSet.of(this.getUp(), this.getUp().m_122424_()));
        super.onReady();
    }

    @Override
    public boolean isPowered() {
        if (!this.isClientSide()) {
            return this.getMainNode().isPowered() || this.storedPower > 0.0f;
        }
        return this.hasPower;
    }

    @Override
    public boolean isActive() {
        return this.isPowered();
    }

    private void setPowered(boolean hasPower) {
        this.hasPower = hasPower;
    }

    @Nullable
    public ICrankable getCrankable(Direction direction) {
        if (direction == this.getUp() || direction == this.getUp().m_122424_()) {
            return new Crankable();
        }
        return null;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (Capabilities.CRANKABLE.equals(capability)) {
            ICrankable crankable = this.getCrankable(facing);
            if (crankable == null) {
                return LazyOptional.empty();
            }
            return Capabilities.CRANKABLE.orEmpty(capability, LazyOptional.of(() -> crankable));
        }
        return super.getCapability(capability, facing);
    }

    class Crankable
    implements ICrankable {
        Crankable() {
        }

        @Override
        public boolean canTurn() {
            return QuartzGrowthAcceleratorBlockEntity.this.storedPower < 1600.0f;
        }

        @Override
        public void applyTurn() {
            if (QuartzGrowthAcceleratorBlockEntity.this.isClientSide()) {
                return;
            }
            boolean needsUpdate = !QuartzGrowthAcceleratorBlockEntity.this.isPowered();
            QuartzGrowthAcceleratorBlockEntity.this.storedPower = Math.min(1600.0f, QuartzGrowthAcceleratorBlockEntity.this.storedPower + 160.0f);
            if (needsUpdate) {
                QuartzGrowthAcceleratorBlockEntity.this.markForUpdate();
            }
        }
    }
}

